/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ModelPartData {
    private static final Map<String, ResourceLocation> resources = new HashMap<String, ResourceLocation>();
    public int color = -1;
    public int colorPattern = -1;
    private ResourceLocation location;
    public String name;
    public byte pattern = 0;
    public boolean playerTexture = false;
    public byte type = 0;

    public ModelPartData(String nameIn) {
        this.name = nameIn;
    }

    public String getColor() {
        StringBuilder str = new StringBuilder(Integer.toHexString(this.color));
        while (str.length() < 6) {
            str.insert(0, "0");
        }
        return str.toString();
    }

    public ResourceLocation getResource() {
        if (this.location != null) {
            return this.location;
        }
        String texture = this.name + "/" + this.type;
        this.location = resources.get(texture);
        if (this.location != null) {
            return this.location;
        }
        this.location = new ResourceLocation("moreplayermodels:textures/" + texture + ".png");
        resources.put(texture, this.location);
        return this.location;
    }

    public void load(NBTTagCompound compound) {
        if (!compound.func_74764_b("Type")) {
            this.type = (byte)-1;
            return;
        }
        this.type = compound.func_74771_c("Type");
        this.color = compound.func_74762_e("Color");
        this.playerTexture = compound.func_74767_n("PlayerTexture");
        this.pattern = compound.func_74771_c("Pattern");
        this.location = null;
    }

    public void setType(int typeIn) {
        this.type = (byte)typeIn;
        this.location = null;
    }

    public String toString() {
        return "ModelPartData: {Color: " + this.color + "; Type: " + this.type + "; Location: " + this.location + "}";
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("Type", this.type);
        compound.func_74768_a("Color", this.color);
        compound.func_74757_a("PlayerTexture", this.playerTexture);
        compound.func_74774_a("Pattern", this.pattern);
        return compound;
    }
}

